var electron = require('electron');// http://electron.atom.io/docs/api
var path = require('path');        // https://nodejs.org/api/path.html
var url = require('url');           // https://nodejs.org/api/url.html

var window = null;

// make sure the application is exited when all windows are closed
electron.app.on('window-all-closed', function() {
  if (process.platform != 'darwin')
    electron.app.quit();
});

// wait until the app is ready
electron.app.once('ready', function () {

  // create a new window
  window = new electron.BrowserWindow({
    width: 300,
    height: 140,

    minWidth: 300,
    minHeight: 140,
    backgroundColor: "#D6D8DC",

    resizable: false,
    show: false
  });

  // load view.html into newly created window
  window.loadURL(url.format({
    pathname: path.join(__dirname, 'view.html'),
    protocol: 'file:',
    slashes: true
  }));

  // disable menubar
  window.setMenu(null);

  // show window when page is ready
  window.once('ready-to-show', function () {
    window.show();
  });
});
