function onlyNumeric(input, output){
    $(input).keydown(function (e) {
            // allow: backspace, delete, tab, escape
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 110]) !== -1 ||
                 // allow: Ctrl/cmd+A
                 (e.keyCode == 65 && (e.ctrlKey === true || e.metaKey === true)) ||
                 // allow: Ctrl/cmd+C
                 (e.keyCode == 67 && (e.ctrlKey === true || e.metaKey === true)) ||
                 // allow: Ctrl/cmd+X
                 (e.keyCode == 88 && (e.ctrlKey === true || e.metaKey === true)) ||
                 (e.keyCode == 86 && (e.ctrlKey === true || e.metaKey === true)) ||
                 // allow: home, end, left, right
                 (e.keyCode >= 35 && e.keyCode <= 39)) {
                     // let it happen, don't do anything
                 return;
             }
            // ensure that it is a number and stop the keypress
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
            }
        });

    // executed when input was pasted
    $(input).on('paste', function(){
        var expr = '/^\\d+$/';
        var pastedText = this;

        setTimeout(function(){
            if (!/^\d+$/.test($(pastedText).val())) {
                $(pastedText).val('');
                $('#out_msg').text('nur Ziffern sind gestattet');
            }
            else if($(pastedText).val().length != 8 ||
                $(pastedText).val().length != 9){
                $('#out_msg').text('min. 8 Ziffern erforderlich');
            }
        }, 100);

    });
}

function getCrossSum(num){
    var result = 0;

    while (num){
        result += num % 10;
        num = Math.floor(num / 10);
    }

    return result;
}


function getDigitsAsInt(str){
    var digits = new Array(0);

    for(var i = 0; i < str.length; i++){
        digits.push(parseInt(str.charAt(i)));
    }

    return digits;
}


function get_checkDigit(ikNum){
    var weighted = new Array(0);
    var crosssums = new Array(0);
    var checkDigit = 0;

    // cut off first two digits
    var ikNumber = ikNum.slice(2, ikNum.length);

    // convert number to single-digits int-array
    var digits = getDigitsAsInt(ikNumber);

    // apply weight to digits
    for (var pos = 0; pos < digits.length; pos++){

        if ((pos % 2) === 0) {
            weighted.push(digits[pos] * 2);
        }
        else{
            weighted.push(digits[pos] * 1);
        }
    }

    // calc crosssums
    for (pos = 0; pos < weighted.length; pos++){
        crosssums.push(getCrossSum(weighted[pos]));
    }

    sumOfCrossSums = 0;
    for (pos = 0; pos < crosssums.length; pos++){
        sumOfCrossSums += crosssums[pos];
    }

    checkDigit = sumOfCrossSums % 10;

    return checkDigit;
}

function validate_checkDigit(ikNum, digit){

    var checkDigit = get_checkDigit(ikNum);

    if (checkDigit == digit){
        return true;
    }
    else{
        return false;
    }

}

// print function for debugging purposes, only works when app is run from terminal
// process.stdout.write('cross: ' + crosssums.toString()); //DEBUG

