// runs when view has been loaded, e.g. app has started
$(function () {

    // allow numeric input only
    onlyNumeric('#in_ikNum','#out_msg');
    $('#out_msg').text("min. 8 Ziffern erforderlich");

    // run when user types
    $('#in_ikNum').bind('input propertychange', function () {
        var msg = '';
        var ikNumber = this.value;

        if (ikNumber.length == 8){

            var checkDigit = get_checkDigit(ikNumber);

            // build output msg
            msg = "Prüfziffer lautet: " + checkDigit.toString();

        }
        else if (ikNumber.length == 9) {

            // save digit to check
            var digit = ikNumber.slice(-1);

            // remove last digit
            ikNumber = ikNumber.slice(0, -1);

            var valid = validate_checkDigit(ikNumber, digit);

            if (valid){
                msg = "IK-Nummer ist gültig";
            }
            else{
                msg = "IK-Nummer ist ungültig";
            }
         }
         else{
            msg = "min. 8 Ziffern erforderlich";
         }

      $('#out_msg').text(msg);
    });

    // focus input box
    $('#in_ikNum').focus();
});
